#include "spil_d.h"
#include "e1432.h"

#define MANUAL_ARM_AND_TRIGGER 0

void main( void )
{
   short buf[1024];
   short list[2];
   int error,groupID,i,k;
   E1432ID e1432_ID;
    
   error = e1432_init_io_driver();
   e1432_set_try_recover(1);  
   
   list[0] = 129;
   error = e1432_assign_channel_numbers(1,list,&e1432_ID);
   if (error) {
      printf("e1432_assign_channel_numbers failed, error %d\n",error);
   }
   
   list[0] = 1;
   groupID = e1432_create_channel_group(e1432_ID,1,list);
   if (groupID >= 0) printf("e1432_create_channel_group returns error %d\n",groupID);
   
   error = e1432_set_analog_input(e1432_ID,
				  E1432_INPUT_CHAN(1),       
				  E1432_INPUT_MODE_VOLT,
				  E1432_INPUT_SOURCE_BNC,
				  E1432_ANTI_ALIAS_ANALOG_ON,
				  E1432_COUPLING_AC,
				  1.0);
   if (error) printf("e1432_set_analog_input() failed, error %d\n",error);
    
   error = e1432_set_trigger(e1432_ID,
			     groupID,      
			     E1432_CHANNEL_OFF,
			     0,0.0,0.0,
			     E1432_TRIGGER_SLOPE_POS,
			     E1432_TRIGGER_MODE_LEVEL);
   if (error) printf("e1432_set_trigger failed.\n");
   
#if MANUAL_ARM_AND_TRIGGER  
   error = e1432_set_auto_trigger(e1432_ID,
				  groupID,
				  E1432_MANUAL_TRIGGER);
   if (error) printf("e1432_set_auto_trigger() failed, error %d\n",error);
   
   error = e1432_set_arm_mode(e1432_ID,
			      groupID,
			      E1432_MANUAL_ARM);
   if (error) printf("e1432_set_auto_arm() failed, error %d\n",error);
#else 
   error = e1432_set_auto_trigger(e1432_ID,
				  groupID,
				  E1432_AUTO_TRIGGER);
   if (error) printf("e1432_set_auto_trigger() failed, error %d\n",error);
   
   error = e1432_set_arm_mode(e1432_ID,
			      groupID,
			      E1432_AUTO_ARM);
   if (error) printf("e1432_set_auto_arm() failed, error %d\n",error);
#endif
    
   error = e1432_set_data_format(e1432_ID,
				 groupID,
				 1024,
				 E1432_DATA_SIZE_16,
				 E1432_BLOCK_MODE,
				 E1432_APPEND_STATUS_OFF);
   if (error) printf("e1432_set_data_format() failed, error %d\n",error);
   
   error = e1432_set_decimation_filter(e1432_ID,
				       groupID,
				       E1432_ONEPASS,
				       E1432_ANTI_ALIAS_DIGITAL_ON,
				       0);
   if (error) printf("e1432_set_decimation_filter() failed, error %d\n",error);
   
   error = e1432_set_fifo_size(e1432_ID,groupID,16384);
   if (error) printf("e1432_set_fifo_size failed, error %d\n",error);
   
   error = e1432_set_clock_freq(e1432_ID,groupID,65536.);
   if (error) printf("e1432_set_clock_freq failed, error %d\n",error);
   
   error = e1432_set_span(e1432_ID,
			  groupID,
			  3200.);
   if (error) printf("e1432_set_span() failed, error %d\n",error);
   
   error = e1432_set_data_port(e1432_ID,
			       groupID,
			       E1432_SEND_PORT_LBUS);
   if (error) printf("e1432_set_data_port() failed, error %d\n",error);
   
   error = e1432_set_lbus_mode(e1432_ID,1,E1432_LBUS_MODE_GENERATE);
   if (error) printf("e1432_set_lbus_mode failed, error %d\n",error);

   error = e1432_reset_lbus(e1432_ID,groupID,E1432_RESET_LBUS_ON);
   if (error) printf("reset_lbus failed, error %d\n",error);
    
   error = lbus_control(LBUS_CTL_RESET,1);
   if (error) printf("lbus_control failed, error is %d\n",error);
   
   error = e1432_reset_lbus(e1432_ID,groupID,E1432_RESET_LBUS_OFF);
   if (error) printf("reset_lbus failed, error %d\n",error);
    
   error = lbus_control(LBUS_CTL_RESET,0);
   if (error) printf("lbus_control failed, error is %d\n",error);
   
   error = e1432_init_measure(e1432_ID,groupID);
   if (error < 0) { printf("e1432_init_measure failed, error %d\n",error); }

#if MANUAL_ARM_AND_TRIGGER
   error = e1432_arm_measure(e1432_ID,groupID,1);
   if (error < 0) { printf("e1432_arm_measure failed$1$, error %d\n",error);  }
   
   error = e1432_trigger_measure(e1432_ID,groupID,1);
   if (error < 0) { printf("e1432_trigger_measure failed, error %d\n",error);  }
#endif
   
   for (i=0; i<100; i++) {
      
      while (!(error = e1432_block_available(e1432_ID,groupID))) {	  
	 opsys_suspend();
      }
      
      if (error < 0) { printf("e1432_block_available failed, error %d\n",error);  }
      
      printf("xfer_lbus_to_ram...");

      for (k = 0; k < (1024/2) / 128; k++)
      {
	  error = xfer_lbus_to_ram(LBUS_TO_MAIN32,(void *)buf+k*256,1,128);
	  if (error < 0) printf("xfer_lbus_to_ram returns %d $1$\n",error);
      }
      printf("done\n");
 
#if MANUAL_ARM_AND_TRIGGER
      error = e1432_arm_measure(e1432_ID,groupID,1);
      if (error < 0) { printf("e1432_arm_measure failed$1$, error %d\n",error);  }
      
      error = e1432_trigger_measure(e1432_ID,groupID,1);
      if (error < 0) { printf("e1432_trigger_measure failed, error %d\n",error); }
#endif
      
   }
   
   exit(0);
}
